<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'        => '您必须接受 :attribute。',
    'active_url'      => ':attribute 不是一个有效的网址。',
    'after'           => ':attribute 必须要晚于 :date。',
    'after_or_equal'  => ':attribute 必须要等于 :date 或更晚。',
    'alpha'           => ':attribute 只能由字母组成。',
    'alpha_dash'      => ':attribute 只能由字母、数字、短划线(-)和下划线(_)组成。',
    'alpha_num'       => ':attribute 只能由字母和数字组成。',
    'array'           => ':attribute 必须是一个数组。',
    'before'          => ':attribute 必须要早于 :date。',
    'before_or_equal' => ':attribute 必须要等于 :date 或更早。',
    'between'         => [
        'numeric' => ':attribute 必须介于 :min - :max 之间。',
        'file'    => ':attribute 必须介于 :min - :max KB 之间。',
        'string'  => ':attribute 必须介于 :min - :max 个字符之间。',
        'array'   => ':attribute 必须只有 :min - :max 个单元。',
    ],
    'boolean'        => ':attribute 必须为布尔值。',
    'confirmed'      => ':attribute 两次输入不一致。',
    'date'           => ':attribute 不是一个有效的日期。',
    'date_equals'    => ':attribute 必须要等于 :date。',
    'date_format'    => ':attribute 的格式必须为 :format。',
    'different'      => ':attribute 和 :other 必须不同。',
    'digits'         => ':attribute 必须是 :digits 位的数字。',
    'digits_between' => ':attribute 必须是介于 :min 和 :max 位的数字。',
    'dimensions'     => ':attribute 图片尺寸不正确。',
    'distinct'       => ':attribute 已经存在。',
    'email'          => ':attribute 不是一个合法的邮箱。',
    'ends_with'      => ':attribute 必须以 :values 为结尾。',
    'exists'         => ':attribute 不存在。',
    'file'           => ':attribute 必须是文件。',
    'filled'         => ':attribute 不能为空。',
    'gt'             => [
        'numeric' => ':attribute 必须大于 :value。',
        'file'    => ':attribute 必须大于 :value KB。',
        'string'  => ':attribute 必须多于 :value 个字符。',
        'array'   => ':attribute 必须多于 :value 个元素。',
    ],
    'gte' => [
        'numeric' => ':attribute 必须大于或等于 :value。',
        'file'    => ':attribute 必须大于或等于 :value KB。',
        'string'  => ':attribute 必须多于或等于 :value 个字符。',
        'array'   => ':attribute 必须多于或等于 :value 个元素。',
    ],
    'image'    => ':attribute 必须是图片。',
    'in'       => '已选的属性 :attribute 非法。',
    'in_array' => ':attribute 没有在 :other 中。',
    'integer'  => ':attribute 必须是整数。',
    'ip'       => ':attribute 必须是有效的 IP 地址。',
    'ipv4'     => ':attribute 必须是有效的 IPv4 地址。',
    'ipv6'     => ':attribute 必须是有效的 IPv6 地址。',
    'json'     => ':attribute 必须是正确的 JSON 格式。',
    'lt'       => [
        'numeric' => ':attribute 必须小于 :value。',
        'file'    => ':attribute 必须小于 :value KB。',
        'string'  => ':attribute 必须少于 :value 个字符。',
        'array'   => ':attribute 必须少于 :value 个元素。',
    ],
    'lte' => [
        'numeric' => ':attribute 必须小于或等于 :value。',
        'file'    => ':attribute 必须小于或等于 :value KB。',
        'string'  => ':attribute 必须少于或等于 :value 个字符。',
        'array'   => ':attribute 必须少于或等于 :value 个元素。',
    ],
    'max' => [
        'numeric' => ':attribute 不能大于 :max。',
        'file'    => ':attribute 不能大于 :max KB。',
        'string'  => ':attribute 不能大于 :max 个字符。',
        'array'   => ':attribute 最多只有 :max 个单元。',
    ],
    'mimes'     => ':attribute 必须是一个 :values 类型的文件。',
    'mimetypes' => ':attribute 必须是一个 :values 类型的文件。',
    'min'       => [
        'numeric' => ':attribute 必须大于等于 :min。',
        'file'    => ':attribute 大小不能小于 :min KB。',
        'string'  => ':attribute 至少为 :min 个字符。',
        'array'   => ':attribute 至少有 :min 个单元。',
    ],
    'not_in'               => '已选的属性 :attribute 非法。',
    'not_regex'            => ':attribute 的格式错误。',
    'numeric'              => ':attribute 必须是一个数字。',
    'password'             => '密码错误',
    'present'              => ':attribute 必须存在。',
    'regex'                => ':attribute 格式不正确。',
    'required'             => ':attribute 不能为空。',
    'required_if'          => '当 :other 为 :value 时 :attribute 不能为空。',
    'required_unless'      => '当 :other 不为 :values 时 :attribute 不能为空。',
    'required_with'        => '当 :values 存在时 :attribute 不能为空。',
    'required_with_all'    => '当 :values 存在时 :attribute 不能为空。',
    'required_without'     => '当 :values 不存在时 :attribute 不能为空。',
    'required_without_all' => '当 :values 都不存在时 :attribute 不能为空。',
    'same'                 => ':attribute 和 :other 必须相同。',
    'size'                 => [
        'numeric' => ':attribute 大小必须为 :size。',
        'file'    => ':attribute 大小必须为 :size KB。',
        'string'  => ':attribute 必须是 :size 个字符。',
        'array'   => ':attribute 必须为 :size 个单元。',
    ],
    'starts_with' => ':attribute 必须以 :values 为开头。',
    'string'      => ':attribute 必须是一个字符串。',
    'timezone'    => ':attribute 必须是一个合法的时区值。',
    'unique'      => ':attribute 已经存在。',
    'uploaded'    => ':attribute 上传失败。',
    'url'         => ':attribute 格式不正确。',
    'uuid'        => ':attribute 必须是有效的 UUID。',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' =>
    array(
        'name' => 'الاسم',
        'username' => 'اسم المُستخدم',
        'email' => 'البريد الالكتروني',
        'first_name' => 'الاسم الأول',
        'last_name' => 'اسم العائلة',
        'password' => 'كلمة المرور',
        'password_confirmation' => 'تأكيد كلمة المرور',
        'city' => 'المدينة',
        'country' => 'الدولة',
        'address' => 'عنوان السكن',
        'phone' => 'الهاتف',
        'mobile' => 'الجوال',
        'age' => 'العمر',
        'sex' => 'الجنس',
        'gender' => 'النوع',
        'day' => 'اليوم',
        'month' => 'الشهر',
        'year' => 'السنة',
        'hour' => 'ساعة',
        'minute' => 'دقيقة',
        'second' => 'ثانية',
        'title' => 'العنوان',
        'description' => 'الوصف',
        'content' => 'المحتوى',
        'terms' => 'الشروط',
        'status' => 'حالة',
        'term' => 'شرط',
        'language_id' => 'لغة',
        'serial_number' => 'رقم سري',
        'category_id' => 'فئة',
        'slider_images' => 'صور المنزلق',
        'latitude' => 'خط العرض',
        'longitude' => 'خط الطول',
        'price' => 'سعر',
        'amount' => 'كمية',
        'order_number' => 'رقم الطلب',
        'end_time' => 'وقت النهاية',
        'date' => 'تاريخ',
        'product_tax_amount' => 'مبلغ ضريبة المنتج',
        'shipping_charge' => 'رسوم الشحن',
        'short_text' => 'نص قصير',
        'value' => 'قيمة',
        'type' => 'يكتب',
        'start_date' => 'تاريخ البدء',
        'end_date' => 'تاريخ الانتهاء',
        'code' => 'شفرة',
        'stock' => 'مخزون',
        'featured_image' => 'صورة مميزة',
        'current_price' => 'السعر الحالي',
        'min_limit' => 'الحد الأدنى',
        'max_limit' => 'الحد الأقصى',
        'image' => 'صورة',
        'new_password' => 'كلمة المرور الجديدة',
        'new_password_confirmation' => 'تأكيد كلمة المرور الجديدة',
        'subtitle' => 'العنوان الفرعي',
        'text' => 'نص',
        'occupation' => 'إشغال',
        'comment' => 'تعليق',
        'rating' => 'تصنيف',
        'question' => 'سؤال',
        'answer' => 'إجابة',
        'email_address' => 'عنوان البريد الإلكتروني',
        'contact_number' => 'رقم الاتصال',
        'url' => 'عنوان URL',
        'delay' => 'تأخير',
        'google_adsense_publisher_id' => 'معرف ناشر جوجل ادسنس',
        'ad_type' => 'نوع الإعلان',
        'resolution_type' => 'نوع القرار',
        'button_text' => 'نص الزر',
        'button_url' => 'عنوان URL للزر',
        'background_color_opacity' => 'عتامة لون الخلفية',
        'base_currency_symbol' => 'رمز العملة الأساسية',
        'base_currency_symbol_position' => 'موضع رمز العملة الأساسية',
        'base_currency_text' => 'نص العملة الأساسية',
        'base_currency_text_position' => 'موضع نص العملة الأساسية',
        'base_currency_rate' => 'سعر العملة الأساسية',
        'website_title' => 'عنوان الموقع',
        'secondary_color' => 'اللون الثانوي',
        'primary_color' => 'اللون الأساسي',
        'preloader' => 'التحميل المسبق',
        'logo' => 'شعار',
        'favicon' => 'رمز المفضلة',
        'smtp_host' => 'مضيف SMTP',
        'smtp_port' => 'منفذ SMTP',
        'encryption' => 'التشفير',
        'from_name' => 'من الاسم',
        'from_mail' => 'من البريد',
        'smtp_password' => 'كلمة مرور SMTP',
        'smtp_username' => 'اسم مستخدم SMTP',
        'mail_subject' => 'موضوع البريد',
        'mail_body' => 'هيئة البريد',
        'cookie_alert_text' => 'نص تنبيه ملفات تعريف الارتباط',
        'role_id' => 'دور',
        'paypal_status' => 'حالة باي بال',
        'paypal_sandbox_status' => 'حالة رمل باي بال',
        'paypal_client_id' => 'معرف عميل باي بال',
        'paypal_client_secret' => 'سر عميل باي بال',
        'instamojo_status' => 'حالة الانستاموجو',
        'instamojo_sandbox_status' => 'حالة رمل Instamojo',
        'instamojo_key' => 'مفتاح واجهة برمجة تطبيقات instamojo',
        'instamojo_token' => 'رمز مصادقة instamojo',
        'paytm_status' => 'حالة paytm',
        'paytm_environment' => 'بيئة paytm',
        'paytm_merchant_key' => 'مفتاح تاجر paytm',
        'paytm_merchant_mid' => 'MID التاجر paytm',
        'paytm_merchant_website' => 'موقع التاجر paytm',
        'paytm_industry_type' => 'نوع صناعة paytm',
        'stripe_status' => 'حالة الشريط',
        'stripe_key' => 'مفتاح الشريط',
        'stripe_secret' => 'سر الشريط',
        'flutterwave_status' => 'حالة موجة الرفرفة',
        'flutterwave_public_key' => 'المفتاح العام لموجة الرفرفة',
        'flutterwave_secret_key' => 'المفتاح السري لموجة الرفرفة',
        'razorpay_status' => 'حالة razorpay',
        'razorpay_key' => 'مفتاح razorpay',
        'razorpay_secret' => 'razorpay سر',
        'mollie_status' => 'حالة مولي',
        'mollie_key' => 'مفتاح مولي API',
        'paystack_status' => 'حالة الراتب',
        'paystack_key' => 'مفتاح واجهة برمجة تطبيقات Paystack',
        'mercadopago_status' => 'حالة ميركادوباجو',
        'mercadopago_sandbox_status' => 'حالة وضع الحماية mercadopago',
        'mercadopago_token' => 'رمز ميركادوباجو',
        'authorize_net_status' => 'حالة Authorize.Net',
        'sandbox_check' => 'فحص رمل',
        'login_id' => 'معرف تسجيل الدخول',
        'transaction_key' => 'مفتاح المعاملة',
        'public_key' => 'المفتاح العام',
        'google_map_api_key' => 'مفتاح API لخرائط جوجل',
        'google_map_radius' => 'دائرة نصف قطرها خريطة جوجل',
        'zoom_account_id' => 'معرف حساب التكبير',
        'zoom_client_id' => 'تكبير معرف العميل',
        'zoom_client_secret' => 'تكبير سر العميل',
        'disqus_short_name' => 'ديسكوس الاسم المختصر',
        'tawkto_status' => 'حالة تاكتو',
        'tawkto_direct_chat_link' => 'توكتو رابط الدردشة المباشر',
        'calender_id' => 'معرف التقويم',
        'whatsapp_number' => 'رقم واتس اب',
        'whatsapp_header_title' => 'عنوان الواتس اب',
        'whatsapp_popup_message' => 'رسالة واتس اب المنبثقة',
        'google_recaptcha_site_key' => 'مفتاح موقع جوجل ريكابتشا',
        'google_recaptcha_status' => 'حالة جوجل ريكابتشا',
        'google_recaptcha_secret_key' => 'جوجل Recapta المفتاح السري',
        'google_client_id' => 'معرف عميل جوجل',
        'google_client_secret' => 'سر عميل جوجل',
        'google_login_status' => 'حالة تسجيل الدخول جوجل',
        'current_password' => 'كلمة المرور الحالية',
        'number_of_bookings' => 'كلمة المرور الحالية',
        'AZIM' => 'AZIM',
        "hero_section_title" => "كلمة المرور الحا",
        "hero_section_subtitle" => "كلمة المرور الحا",
        "city_section_title" => "كلمة المرور الحا",
        "featured_section_title" => "كلمة المرور الحا",
        "featured_section_text" => "كلمة المرور الحا",
        "featured_room_section_title" => "كلمة المرور الحا",
        "featured_room_section_button_text" => "كلمة المرور الحا",
        "counter_section_video_link" => "كلمة المرور الحا",
        "blog_section_title" => "كلمة المرور الحا",
        "blog_section_button_text" => "كلمة المرور الحا",
        "call_to_action_section_title" => "كلمة المرور الحا",
        "call_to_action_button_url" => "كلمة المرور الحا",
        "call_to_action_section_btn" => "كلمة المرور الحا",
        "testimonial_section_title" => "كلمة المرور الحا",
        "benifit_section_title" => "كلمة المرور الحا",
        "testimonial_section_subtitle" => "كلمة المرور الحا",
        "testimonial_section_clients" => "كلمة المرور الحا",
    ),
];
